﻿// See https://aka.ms/new-console-template for more information



using System.Drawing;

Console.BackgroundColor = ConsoleColor.Black;
Console.ForegroundColor = ConsoleColor.Cyan;
Console.Clear();
Console.Beep();
Console.Title = "BOSS BATTLE: MANTICORE";
Console.WriteLine("Begin Battle!");
   
//INITIALIZING GAME STARTING STATE (Manticore= 10 health, consolas = 15)
int bossHealth = 10;
int bossMaxHealth = 10;

int townHealth = 15;
int townMaxHealth = 15;

int round = 1;

//PLAYER 1s TURN
Console.WriteLine($"Choose distance from town (0-100):");
Random rnd = new Random();
int manticoreLocation= rnd.Next(0, 101);
Console.ForegroundColor = ConsoleColor.Red;
Console.WriteLine($"The Manticore moves to position {manticoreLocation}");
Thread.Sleep(200);


// BEFORE PLAYER 2s TURN
Console.Clear();
Console.ForegroundColor = ConsoleColor.White;
Console.WriteLine("Guess the location of the Manticore! Shoot it down and save the town!");
Console.WriteLine("You will find that different rounds result in different types of cannon shots");
Console.WriteLine("Beat the boss, before the boss beats you...");


//GAME LOOP
while (bossHealth != 0 && townHealth != 0)
   {
      RoundStart();
      DisplayCannonDamage();
      
//player 2 Manticore Hunting Choice
   Console.ForegroundColor = ConsoleColor.Blue;
   Console.WriteLine("Enter desired shot location: ");
   Console.ForegroundColor = ConsoleColor.Yellow;
   int playerChoice = int.Parse(Console.ReadLine());
   while (playerChoice > 100 || playerChoice < 0)
   {
      Console.WriteLine("Please enter a number between 0 and 100.");
      int.TryParse(Console.ReadLine(), out playerChoice);
   }
   Console.ForegroundColor = ConsoleColor.Magenta;
   Console.WriteLine($"The cannon aims at position {playerChoice}");
   
   //evaluates shot/ damage application
   CannonShot(playerChoice,manticoreLocation);
   
   //shot feedback
      if (playerChoice > manticoreLocation)
      {
         Console.ForegroundColor = ConsoleColor.Yellow;
         Console.WriteLine("You overshot!");
      }
      else if (playerChoice < manticoreLocation)
      {
         Console.ForegroundColor = ConsoleColor.Yellow;
         Console.WriteLine("You shot short of the Manticore!");
      }
      else if (playerChoice == manticoreLocation)
      {
         Console.ForegroundColor = ConsoleColor.Green;
         Console.WriteLine("You hit the Manticore!");
         // Damage will be handled by CannonShot()
      }

      // Check win condition
      if (bossHealth <= 0)
      {
         Console.WriteLine("You defeated the Manticore! The city of Consolas is saved!");
         break;
      }
      // decrease after turn and then check lose condition
      townHealth--;
      if (townHealth <= 0)
      {
         Console.ForegroundColor = ConsoleColor.DarkRed;
         Console.WriteLine("The city of Consolas has been destroyed! You failed to stop the Manticore.");
         Console.WriteLine($"The airship was located at {manticoreLocation}");
         break;
      }
      
      round++; // Move to the next round
   }


   
// Cannon Damage
void CannonShot(int playerChoice, int manticoreLocation)
{
   if (playerChoice == manticoreLocation)
   {
      if (round % 3 == 0 && round % 5 == 0)
      {
         Console.ForegroundColor = ConsoleColor.DarkCyan;
         bossHealth -= 10;
      }
      else if (round % 3 == 0)
      {
         Console.ForegroundColor = ConsoleColor.DarkRed;
         bossHealth -= 3;
      }
      else if (round % 5 == 0)
      {
         Console.ForegroundColor = ConsoleColor.DarkYellow;
         bossHealth -= 5;
      }
      else
      {
         bossHealth--; // Default damage
      }
   }
}
// Display expected cannon damage
void DisplayCannonDamage()
{
   if (round % 3 == 0 && round % 5 == 0)
   {
      Console.ForegroundColor = ConsoleColor.DarkCyan;
      Console.WriteLine("Cannon shot will do 10 damage on hit this round.");
   }
   else if (round % 5 == 0)
   {
      Console.ForegroundColor = ConsoleColor.DarkYellow;
      Console.WriteLine("Cannon shot will do 5 damage on hit this round.");
   }
   else if (round % 3 == 0)
   {
      Console.ForegroundColor = ConsoleColor.DarkRed;
      Console.WriteLine("Cannon shot will do 3 damage on hit this round.");
   }
   else
   {
      Console.ForegroundColor = ConsoleColor.Gray;
      Console.WriteLine("Cannon shot will do 1 damage on hit this round.");
   }
}

//Start of Round + statuses
void RoundStart()
{
      //Round text and color
      Console.ForegroundColor = ConsoleColor.Cyan;
      Console.WriteLine("------------------------------------------");
      Console.ForegroundColor = ConsoleColor.Blue;
      Console.Write($"STATUS: ROUND ({round}) ");

      // color for boss health based on value
      if (bossHealth < 5)
      {
         Console.ForegroundColor = ConsoleColor.Red; // Red for boss health below 5
      }
      else if (bossHealth < 10)
      {
         Console.ForegroundColor = ConsoleColor.Yellow; // Yellow for boss health below 10
      }
      else
      {
         Console.ForegroundColor = ConsoleColor.Green; // Default color when boss health is 10 or higher
      }
      Console.Write($"BOSS: {bossHealth}/{bossMaxHealth} ");

      // color for city on value and text
      if (townHealth < 5)
      {
         Console.ForegroundColor = ConsoleColor.Red; // Red for boss health below 5
      }
      else if (townHealth < 10)
      {
         Console.ForegroundColor = ConsoleColor.Yellow; // Yellow for boss health below 10
      }
      else
      {
         Console.ForegroundColor = ConsoleColor.Green; // Default color when boss health is 10 or higher
      }
      Console.Write($"CITY: {townHealth}/{townMaxHealth}");
      
      // Console.ResetColor();
      Console.BackgroundColor= ConsoleColor.Black;
      Console.WriteLine();
   }
   